/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.PlayerCanvas;
import java.util.Vector;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.List;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.midlet.MIDlet;

public class AudioPlayer
extends MIDlet
implements CommandListener {
    private static PlayerCanvas playerGUI = null;
    private static List theList;
    private static Vector urls;
    private Command exitCommand = new Command("Exit", 7, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Display display;

    public static List getList() {
        return theList;
    }

    public void startApp() {
        this.display = Display.getDisplay((MIDlet)this);
        this.initPlayList();
        this.display.setCurrent((Displayable)theList);
    }

    public void pauseApp() {
    }

    public void destroyApp(boolean unconditional) {
        if (playerGUI != null) {
            playerGUI.stopSound();
            playerGUI = null;
        }
        this.display.setCurrent(null);
    }

    public void commandAction(Command c, Displayable s) {
        if (c == this.exitCommand) {
            this.destroyApp(true);
            this.notifyDestroyed();
        } else if (s == theList && c == List.SELECT_COMMAND || c == this.playCommand) {
            int i = theList.getSelectedIndex();
            if (i == 0) {
                try {
                    Manager.playTone((int)60, (int)200, (int)90);
                }
                catch (MediaException ex) {
                    System.out.println("can't play tone");
                }
            } else if (i > 0) {
                if (playerGUI == null) {
                    playerGUI = new PlayerCanvas(this.display);
                } else {
                    playerGUI.stopSound();
                }
                playerGUI.setParam((String)urls.elementAt(i));
                playerGUI.playSound();
                this.display.setCurrent((Displayable)playerGUI);
            }
        }
    }

    private void initPlayList() {
        String nthURL;
        String url;
        urls = new Vector();
        theList = new List("MIDP Audio Player", 3);
        for (int n = 1; n < 32 && (url = this.getAppProperty(nthURL = "PlayerURL-" + n)) != null && url.length() != 0; ++n) {
            String nthTitle = "PlayerTitle-" + n;
            String title = this.getAppProperty(nthTitle);
            if (title == null || title.length() == 0) {
                title = url;
            }
            urls.addElement(url);
            theList.append(title, null);
        }
        theList.addCommand(this.exitCommand);
        theList.addCommand(this.playCommand);
        theList.setCommandListener((CommandListener)this);
    }
}

