/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import example.audiodemo.AudioPlayer;
import java.io.ByteArrayInputStream;
import java.io.InputStream;
import javax.microedition.lcdui.Alert;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Command;
import javax.microedition.lcdui.CommandListener;
import javax.microedition.lcdui.Display;
import javax.microedition.lcdui.Displayable;
import javax.microedition.lcdui.Graphics;
import javax.microedition.lcdui.Image;
import javax.microedition.media.Manager;
import javax.microedition.media.MediaException;
import javax.microedition.media.Player;
import javax.microedition.media.control.VolumeControl;
import javax.microedition.rms.RecordStore;

public class PlayerCanvas
extends Canvas
implements Runnable,
CommandListener {
    private Player player;
    private Thread dThread;
    private Image logo = null;
    private Display parentDisplay;
    private Command backCommand = new Command("Back", 2, 1);
    private Command playCommand = new Command("Play", 8, 1);
    private Command pauseCommand = new Command("Pause", 8, 10);
    private boolean disMTime;
    private boolean interrupted;
    private String title;
    private String url;
    private String mtime;

    public PlayerCanvas(Display parentDisplay) {
        this.parentDisplay = parentDisplay;
        this.initialize();
    }

    private void initialize() {
        this.addCommand(this.backCommand);
        this.addCommand(this.pauseCommand);
        this.setCommandListener(this);
        try {
            this.logo = Image.createImage((String)"/icons/logo.png");
        }
        catch (Exception ex) {
            this.logo = null;
        }
        if (this.logo == null) {
            System.out.println("can not load logo.png");
        }
    }

    public void commandAction(Command c, Displayable s) {
        if (s == this) {
            if (c == this.backCommand) {
                this.stopSound();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
                this.parentDisplay.setCurrent((Displayable)AudioPlayer.getList());
            } else if (c == this.playCommand) {
                this.playSound();
                this.removeCommand(this.playCommand);
                this.addCommand(this.pauseCommand);
            } else if (c == this.pauseCommand) {
                this.pauseSound();
                this.removeCommand(this.pauseCommand);
                this.addCommand(this.playCommand);
            }
        }
    }

    public void setParam(String url) {
        this.url = url;
        int idx = url.lastIndexOf(47);
        this.title = url.substring(idx + 1);
    }

    public void playSound() {
        if (this.title == null || this.url == null) {
            return;
        }
        if (this.dThread == null) {
            this.dThread = new Thread(this);
            this.mtime = "";
            this.disMTime = true;
            this.interrupted = false;
            this.dThread.start();
        } else if (this.player != null) {
            try {
                this.player.start();
            }
            catch (Exception exception) {
                // empty catch block
            }
        }
    }

    public void stopSound() {
        try {
            this.interrupted = true;
            this.disMTime = false;
            this.dThread = null;
            Thread.sleep(100L);
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
    }

    void pauseSound() {
        try {
            if (this.player != null) {
                this.player.stop();
            }
        }
        catch (MediaException mediaException) {
            // empty catch block
        }
    }

    void createPlayer() {
        try {
            if (this.url.startsWith("http:")) {
                this.player = Manager.createPlayer((String)this.url);
            } else if (this.url.startsWith("resource")) {
                int idx = this.url.indexOf(58);
                String loc = this.url.substring(idx + 1);
                InputStream is = this.getClass().getResourceAsStream(loc);
                String ctype = this.url.endsWith("wav") ? "audio/x-wav" : "audio/x-tone-seq";
                this.player = Manager.createPlayer((InputStream)is, (String)ctype);
            } else if (this.url.startsWith("rms:")) {
                byte[] adata;
                RecordStore rs;
                boolean found = false;
                ByteArrayInputStream stream = null;
                try {
                    rs = RecordStore.openRecordStore((String)"adrms", (boolean)false);
                    adata = rs.getRecord(1);
                    rs.closeRecordStore();
                    stream = new ByteArrayInputStream(adata);
                    found = true;
                }
                catch (Exception ex) {
                    found = false;
                    this.createMyRecordStore();
                }
                if (!found) {
                    rs = RecordStore.openRecordStore((String)"adrms", (boolean)false);
                    adata = rs.getRecord(1);
                    rs.closeRecordStore();
                    stream = new ByteArrayInputStream(adata);
                }
                String ctype = this.url.endsWith("wav") ? "audio/x-wav" : "audio/x-tone-seq";
                this.player = Manager.createPlayer((InputStream)stream, (String)ctype);
            }
            this.player.setLoopCount(-1);
        }
        catch (Exception ex) {
            if (this.player != null) {
                this.player.close();
                this.player = null;
            }
            Alert alert = new Alert("Warning", "Cannot create player", null, null);
            alert.setTimeout(1000);
            this.parentDisplay.setCurrent((Displayable)alert);
        }
    }

    private void createMyRecordStore() {
        try {
            int tmp;
            int idx = this.url.indexOf(58);
            String loc = this.url.substring(idx + 1);
            InputStream is = this.getClass().getResourceAsStream(loc);
            byte[] data = new byte[4096];
            int nread = 0;
            while ((tmp = is.read(data, nread, 1024)) > 0) {
                nread += tmp;
            }
            is.close();
            RecordStore rs = RecordStore.openRecordStore((String)"adrms", (boolean)true);
            int id = rs.addRecord(data, 0, nread);
            rs.closeRecordStore();
            System.out.println("create a new record store");
        }
        catch (Exception ex) {
            ex.printStackTrace();
        }
    }

    public void paint(Graphics g) {
        int w = this.getWidth();
        int h = this.getHeight();
        g.setColor(0);
        g.fillRect(0, 0, w, h);
        g.setColor(0xFF7F00);
        g.drawString("Audio Player", w / 2, 8, 17);
        if (this.logo != null) {
            g.drawImage(this.logo, w / 2, 30, 17);
        }
        g.setColor(0xFF7F00);
        g.drawString("Audio Player", w / 2, 8, 17);
        g.drawString(this.title, w / 2, 84, 17);
        g.drawString(this.mtime, 0, 150, 20);
    }

    public void run() {
        if (this.player == null) {
            try {
                this.createPlayer();
                this.player.realize();
                long dur = this.player.getDuration();
                if (dur != -1L) {
                    this.title = this.title + " [" + this.timeFM(dur) + "]";
                }
                this.player.start();
            }
            catch (Exception ex) {
                // empty catch block
            }
        }
        while (!this.interrupted) {
            try {
                if (this.disMTime) {
                    this.mtime = this.timeFM(this.player.getMediaTime());
                    this.repaint(0, 110, 100, 170);
                }
                Thread.sleep(100L);
            }
            catch (Exception exception) {}
        }
    }

    protected void keyPressed(int keycode) {
        switch (keycode) {
            case 42: {
                this.changeVolume(-10);
                break;
            }
            case 35: {
                this.changeVolume(10);
            }
        }
    }

    private void changeVolume(int diff) {
        VolumeControl vc;
        if (this.player != null && (vc = (VolumeControl)this.player.getControl("VolumeControl")) != null) {
            int cv = vc.getLevel();
            int n = vc.setLevel(cv += diff);
        }
    }

    private String timeFM(long val) {
        String ret = "";
        int mval = (int)(val / 1000L);
        int sec = mval / 1000;
        int min = sec / 60;
        ret = min >= 10 ? ret + min + ":" : (min > 0 ? "0" + min + ":" : "00:");
        ret = sec >= 10 ? ret + sec + "." : (sec > 0 ? ret + "0" + sec + "." : ret + "00.");
        mval = mval % 1000 / 100;
        ret = ret + mval;
        return ret;
    }
}

