/*
 * Decompiled with CFR 0.152.
 */
package example.audiodemo;

import java.util.Random;
import javax.microedition.lcdui.Canvas;
import javax.microedition.lcdui.Graphics;
import javax.microedition.media.Manager;

class SmallBall
implements Runnable {
    static Random random = new Random();
    static int delay = 20;
    static int[][] matrix = new int[][]{{1, -1, -1, 1, 1, 1}, {-1, -1, 1, 1, -1, 1}, null, {1, 1, -1, -1, 1, -1}, {-1, 1, 1, -1, -1, -1}};
    int top;
    int left;
    int width;
    int height;
    int posX;
    int posY;
    int radius = 5;
    int ballSize = this.radius * 2;
    int deltaX;
    int deltaY;
    Graphics g;
    Canvas canvas;
    int note = 60;
    int clr = 0;
    public boolean stop;

    static void slower() {
        if ((delay += 10) > 100) {
            delay = 100;
        }
    }

    static void faster() {
        if ((delay -= 10) < 10) {
            delay = 10;
        }
    }

    SmallBall(Canvas c, int left, int top, int width, int height) {
        this.canvas = c;
        this.left = left + 1;
        this.top = top + 1;
        this.width = width - (2 * this.radius + 2);
        this.height = height - (2 * this.radius + 2);
        this.posX = (random.nextInt() >>> 1) % (this.width - 20) + 10;
        this.posY = (random.nextInt() >>> 1) % (this.height - 20) + 10;
        this.deltaX = random.nextInt() & 1;
        this.deltaY = random.nextInt() & 1;
        if (this.deltaX == 0) {
            this.deltaX = -1;
        }
        if (this.deltaY == 0) {
            this.deltaY = -1;
        }
    }

    public void setNote(int note) {
        this.note = note;
    }

    public void run() {
        int right = this.left + this.width;
        int bottom = this.top + this.height;
        this.stop = false;
        while (!this.stop) {
            this.ballSize = this.radius * 2;
            int direction = this.deltaX + this.deltaY;
            if (direction == 0) {
                direction = this.deltaX + 2 * this.deltaY;
            }
            int collision = 0;
            if (this.posX <= this.left || this.posX >= right) {
                ++collision;
            }
            if (this.posY <= this.top || this.posY >= bottom) {
                collision += 2;
            }
            if (collision != 0) {
                try {
                    Manager.playTone((int)this.note, (int)100, (int)100);
                }
                catch (Exception ex) {
                    System.out.println("failed to play tone");
                }
                collision = (collision - 1) * 2;
                this.deltaX = matrix[direction + 2][collision];
                this.deltaY = matrix[direction + 2][collision + 1];
            }
            this.posX += this.deltaX;
            this.posY += this.deltaY;
            this.canvas.repaint();
            try {
                Thread.sleep(delay);
            }
            catch (InterruptedException e) {}
        }
    }

    void paint(Graphics g) {
        g.setColor(this.clr);
        g.fillArc(this.posX, this.posY, this.ballSize, this.ballSize, 0, 360);
    }

    public void setColor(int clr) {
        this.clr = clr;
    }

    public String toString() {
        return super.toString() + " x = " + this.posX + ", y = " + this.posY;
    }
}

